package gov.va.caret.model.support;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.liferay.util.portlet.PortletProps;

import gov.va.caret.util.Toolbox;

public enum WorkType {
	ONLINE_APP(getDouble(PortletProps.get("onlineApp.due.days"), 1.0 ), true, true),
	CSC_APP(getDouble(PortletProps.get("cscApp.due.days"), 1.0 ), true, true),
	HEC_APP(getDouble(PortletProps.get("cscApp.due.days"), 1.0 ), true, true),
	FACILITY_APP(getDouble(PortletProps.get("facilityApp.due.days"), 1.0 )),
	SOC( getDouble(PortletProps.get("soc.due.days"), 25.0 )),
	SOC_FOLLOWUP( getDouble(PortletProps.get("soc.followup.due.days"), -1.0 )),
	CESP(getDouble(PortletProps.get("cesp.due.days"), -1.0 )),
	CESP_CSC(getDouble(PortletProps.get("cesp.csc.due.days"), -1.0 )),
	REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), true, true),
	HEC_REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), true, true),
	HRC_REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), true, true),
	CSL_REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), true, true),
	CALL_REFERRAL(getDouble(PortletProps.get("callReferral.due.days"), 5.0 ), true, false),
	HOME_VISIT(getDouble(PortletProps.get("homeVisit.due.days"), 10.0 ), true, false),	
	APP_DELAY(getDouble(PortletProps.get("visn.waiver.days"), 121.0 ), true, false, 20),
	DELAY_REVIEWED(getDouble(PortletProps.get("visn.approval.days"), 20.0 ), true, false),
	CSC_WAIVER(getDouble(PortletProps.get("csc.waiver.days"), 90.0 )),
	REJECTED_PAYMENT(-1),
	DUPLICATE_PAYMENT(-1),
	LOST_CHECK(1),
	RECOUPMENT(-1),
	HELD_PAYMENT(-1),
	CSC_WORK(-1),
	VETERAN_CG_INFO_CHANGE(-1),
	TIU(-1),
	CBOPC_WI(-1),   //for New Application approved, write TIU Note
	// VENDOR_PII_UPDATE(getDouble(PortletProps.get("pii.update.days"), -1.0 )),
	// VENDOR_INSURANCE_UPDATE(getDouble(PortletProps.get("insurance.update.days"), -1.0 )), 
	DISPOSITION_UPDATE(-1),
	DISP_APPROVED(-1),
	DISP_REVOKED(-1),
	DISP_REINSTATED(-1),
//	INSURANCE_UPDATE(-1), 
	TIER_UPDATE(-1), 
	VCG_TRANSFER(-1), 
	ADDRESS_CHANGE(-1),
	PII_CHANGE(-1),
	NAME_CHANGE(-1),
	INSURANCE_CHANGE(-1),
	FACILITY_CHANGE(-1),
	GENERAL_CG_ASSIGNMENT(-1);
	
	double days;
	double expires = -1;
	int dayRule = TYPE_CALENDAR_DAYS;
	boolean filterRegistered = false;
	boolean isDocType = false;
	
	public static final long DUPLICATE_APPLICATION_CODE = -1;
	public static final long INVALID_APPLICATION_CODE = -2;
	public static final int TYPE_CALENDAR_DAYS = 0;
	public static final int TYPE_BUSINESS_DAYS = 1;

	
	WorkType( double days, int type, boolean filterRegistered, boolean isDocType ){
		this( days, filterRegistered, isDocType );
		this.dayRule = type;
	}
	WorkType( double days, boolean filterRegistered, boolean isDocType ){
		this.isDocType = isDocType;
		this.days = days;
		this.filterRegistered = filterRegistered;
	}
	
	WorkType( double days, boolean filterRegistered, boolean isDocType, double expiration  ){
		this.isDocType = isDocType;
		this.days = days;
		this.filterRegistered = filterRegistered;
		this.expires = expiration;
	}
	
	WorkType( double days ){
		this.days = days;
	}

	private static double getDouble(String string, double d) {
		if ( string == null || string.isEmpty() ){
			return d;
		}
		try{
			return Double.valueOf(string);
		} catch ( NumberFormatException nfe ){}
		return d;
	}
	
	public Date getExpirationDate(Date currDate) {
		if ( dayRule == TYPE_BUSINESS_DAYS ) {
			return getBusinessExpiresDate(currDate);
		}
		if ( expires == -1 ){
			return null;
		}
		return Toolbox.adjustDate(expires, currDate, true);
	}

	public Date getDueDate(Date createDate) {
		if ( dayRule == TYPE_BUSINESS_DAYS ) {
			return getBusinessDueDate(createDate);
		}
		if ( days == -1 ){
			return null;
			//return createDate;
		}
		return Toolbox.adjustDate(days, createDate, true);
	}
	
	public Date getBusinessDueDate(Date startDate)
	{
		if ( days == -1 ){
			return null;
		}else{
			return Toolbox.adjustBusinessDate(days, startDate, true);			
		}
	}
	
	public Date getBusinessExpiresDate(Date startDate){
		if ( expires == -1 ){
			return null;
		}else{
			return Toolbox.adjustBusinessDate(expires, startDate, true);			
		}
	}
	
	public boolean isDocType(){
		return isDocType;
	}
	
	public static List<WorkType> getFilterRegistered(){
		List<WorkType> list = new ArrayList<WorkType>();
		for ( WorkType workType: WorkType.values() ){
			if ( workType.filterRegistered ){
				list.add(workType);
			}
		}
		return list;
	}
	
}